/**
* \file: watch.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AAM_CONTROL_WATCH_H
#define AAM_CONTROL_WATCH_H

#include <sys/epoll.h>
#include "automounter_types.h"


typedef struct watch_t watch_t;

typedef void (*watch_callback_func_t)(watch_t *watch, uint32_t event);

typedef enum
{
  WATCH_TIMED_OUT,
  WATCH_INTERRUPTED,
  WATCH_EVENT_PROCESSED,
  WATCH_ERROR
} watch_process_event_result_t;

typedef struct watch_t
{
	int pollfd;

	uint32_t event_mask;

	watch_callback_func_t callback_func;

	void *data;

} watch_t;

error_code_t watch_init(void);

void watch_deinit(void);

error_code_t watch_add_event_source(watch_t *watch, uint32_t event_mask);

error_code_t watch_modify_watch_events(watch_t *watch, uint32_t event_mask);

error_code_t watch_remove_event_source(watch_t *watch);

watch_process_event_result_t watch_wait_for_and_process_event(void);

#endif
